<?php

declare(strict_types=1);

namespace Strix\BlueMedia\Api;

use Shopware\Core\Framework\Routing\Annotation\RouteScope;
use Strix\BlueMedia\Processor\GatewaySynchronizationProcessor;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\Routing\Annotation\Route;

/**
 * @RouteScope(scopes={"api"})
 */
class GatewayController extends AbstractController
{
    /**
     * @var GatewaySynchronizationProcessor
     */
    private $gatewaySynchronizationProcessor;

    /**
     * @param GatewaySynchronizationProcessor $gatewaySynchronizationProcessor
     */
    public function __construct(
       GatewaySynchronizationProcessor $gatewaySynchronizationProcessor
   ) {
       $this->gatewaySynchronizationProcessor = $gatewaySynchronizationProcessor;
   }

    /**
     * @Route("/api/v{version}/_action/gateway/synchronize", name="api.action.gateway.synchronize", methods={"GET"})
     */
    public function synchronize(): JsonResponse
    {
        $this->gatewaySynchronizationProcessor->processGatewaySynchronization();
        return new JsonResponse(['result' => true]);
    }
}
