<?php

declare(strict_types=1);

namespace Strix\BlueMedia\Entity;

use Shopware\Core\Checkout\Payment\PaymentMethodEntity;
use Shopware\Core\Content\Media\MediaEntity;
use Shopware\Core\Framework\DataAbstractionLayer\Entity;
use Shopware\Core\Framework\DataAbstractionLayer\EntityIdTrait;

class GatewayEntity extends Entity
{
    use EntityIdTrait;

    /**
     * @var string
     */
    protected $id;

    /**
     * @var string
     */
    protected $gatewayCurrency;

    /**
     * @var bool
     */
    protected $gatewayStatus;

    /**
     * @var int
     */
    protected $gatewayId;

    /**
     * @var string
     */
    protected $bankName;

    /**
     * @var string
     */
    protected $gatewayName;

    /**
     * @var string|null
     */
    protected $gatewayDescription;

    /**
     * @var string
     */
    protected $gatewayType;

    /**
     * @var string|null
     */
    protected $gatewayLogoUrl;

    /**
     * @var bool
     */
    protected $isSeparatedMethod;

    /**
     * @var bool
     */
    protected $forceDisable;

    /**
     * @var int|null
     */
    protected $position;

    /**
     * @var bool
     */
    protected $useOwnLogo;

    /**
     * @var string|null
     */
    protected $mediaId;

    /**
     * @var MediaEntity|null
     */
    protected $media;

    /**
     * @var string|null
     */
    protected $paymentMethodId;

    /**
     * @var PaymentMethodEntity|null
     */
    protected $paymentMethod;

    /**
     * @var \DateTimeInterface
     */
    protected $createdAt;

    /**
     * @var \DateTimeInterface
     */
    protected $updatedAt;

    public function getId(): string
    {
        return $this->id;
    }

    public function setId(string $id): void
    {
        $this->id = $id;
    }

    public function getGatewayCurrency(): string
    {
        return $this->gatewayCurrency;
    }

    public function setGatewayCurrency(string $gatewayCurrency): void
    {
        $this->gatewayCurrency = $gatewayCurrency;
    }

    public function getGatewayStatus(): bool
    {
        return $this->gatewayStatus;
    }

    public function setGatewayStatus(bool $gatewayStatus): void
    {
        $this->gatewayStatus = $gatewayStatus;
    }

    public function getGatewayId(): int
    {
        return $this->gatewayId;
    }

    public function setGatewayId(int $gatewayId): void
    {
        $this->gatewayId = $gatewayId;
    }

    public function getBankName(): string
    {
        return $this->bankName;
    }

    public function setBankName(string $bankName): void
    {
        $this->bankName = $bankName;
    }

    public function getGatewayName(): string
    {
        return $this->gatewayName;
    }

    public function setGatewayName(string $gatewayName): void
    {
        $this->gatewayName = $gatewayName;
    }

    public function getGatewayDescription(): ?string
    {
        return $this->gatewayDescription;
    }

    public function setGatewayDescription(?string $gatewayDescription): void
    {
        $this->gatewayDescription = $gatewayDescription;
    }

    public function getGatewayType(): string
    {
        return $this->gatewayType;
    }

    public function setGatewayType(string $gatewayType): void
    {
        $this->gatewayType = $gatewayType;
    }

    public function getGatewayLogoUrl(): ?string
    {
        return $this->gatewayLogoUrl;
    }

    public function setGatewayLogoUrl(?string $gatewayLogoUrl): void
    {
        $this->gatewayLogoUrl = $gatewayLogoUrl;
    }

    public function getIsSeparatedMethod(): bool
    {
        return $this->isSeparatedMethod;
    }

    public function setIsSeparatedMethod(bool $isSeparatedMethod): void
    {
        $this->isSeparatedMethod = $isSeparatedMethod;
    }

    public function getForceDisable(): bool
    {
        return $this->forceDisable;
    }

    public function setForceDisable(bool $forceDisable): void
    {
        $this->forceDisable = $forceDisable;
    }

    public function getPosition(): ?int
    {
        return $this->position;
    }

    public function setPosition(?int $position): void
    {
        $this->position = $position;
    }

    public function getUseOwnLogo(): bool
    {
        return $this->useOwnLogo;
    }

    public function setUseOwnLogo(bool $useOwnLogo): void
    {
        $this->useOwnLogo = $useOwnLogo;
    }

    public function getMediaId(): ?string
    {
        return $this->mediaId;
    }

    public function setMediaId(?string $mediaId): void
    {
        $this->mediaId = $mediaId;
    }

    public function getMedia(): ?MediaEntity
    {
        return $this->media;
    }

    public function setMedia(?MediaEntity $media): void
    {
        $this->media = $media;
    }

    public function getPaymentMethodId(): ?string
    {
        return $this->paymentMethodId;
    }

    public function setPaymentMethodId(?string $paymentMethodId): void
    {
        $this->paymentMethodId = $paymentMethodId;
    }

    public function getPaymentMethod(): ?PaymentMethodEntity
    {
        return $this->paymentMethod;
    }

    public function setPaymentMethod(?PaymentMethodEntity $paymentMethod): void
    {
        $this->paymentMethod = $paymentMethod;
    }

    public function getCreatedAt(): \DateTimeInterface
    {
        return $this->createdAt;
    }

    public function setCreatedAt(\DateTimeInterface $createdAt): void
    {
        $this->createdAt = $createdAt;
    }

    public function getUpdatedAt(): \DateTimeInterface
    {
        return $this->updatedAt;
    }

    public function setUpdatedAt(\DateTimeInterface $updatedAt): void
    {
        $this->updatedAt = $updatedAt;
    }
}
