<?php

declare(strict_types=1);

namespace Strix\BlueMedia\Helper;

use Shopware\Core\Framework\DataAbstractionLayer\EntityRepositoryInterface;
use Shopware\Core\Framework\DataAbstractionLayer\Exception\InconsistentCriteriaIdsException;
use Shopware\Core\Framework\DataAbstractionLayer\Search\Criteria;
use Shopware\Core\System\SalesChannel\Context\SalesChannelContextPersister;
use Shopware\Core\System\SalesChannel\SalesChannelContext;
use Strix\BlueMedia\Entity\GatewayEntity;

class SessionSelectedGatewayHelper
{
    const SELECTED_GATEWAY_KEY = 'BlueMediaGateway';

    /**
     * @var SalesChannelContextPersister
     */
    private $contextPersister;

    /**
     * @var EntityRepositoryInterface
     */
    private $bmGatewayRepository;

    /**
     * @param SalesChannelContextPersister $contextPersister
     * @param EntityRepositoryInterface $bmGatewayRepository
     */
    public function __construct(
        SalesChannelContextPersister $contextPersister,
        EntityRepositoryInterface $bmGatewayRepository

    ) {
        $this->contextPersister = $contextPersister;
        $this->bmGatewayRepository = $bmGatewayRepository;
    }

    /**
     * @param string $uuid
     * @param SalesChannelContext $salesChannelContext
     */
    public function selectGateway(string $uuid, SalesChannelContext $salesChannelContext): void
    {
        $this->contextPersister->save($salesChannelContext->getToken(), [self::SELECTED_GATEWAY_KEY => $uuid]);
    }

    /**
     * @param SalesChannelContext $salesChannelContext
     * @return string|null
     */
    public function getSelectedGatewayUuidd(SalesChannelContext $salesChannelContext): ?string
    {
        $payload = $this->contextPersister->load($salesChannelContext->getToken());
        if(array_key_exists(self::SELECTED_GATEWAY_KEY, $payload)) {
            return (string) $payload[self::SELECTED_GATEWAY_KEY];
        }
        return null;
    }

    /**
     * @param SalesChannelContext $salesChannelContext
     * @return GatewayEntity|null
     */
    public function getSelectedGateway(SalesChannelContext $salesChannelContext): ?GatewayEntity
    {
        $gatewayUuid = $this->getSelectedGatewayUuidd($salesChannelContext);
        if($gatewayUuid){
            try {
                $criteria = new Criteria([$gatewayUuid]);
                return $this->bmGatewayRepository->search($criteria, $salesChannelContext->getContext())->first();
            } catch (InconsistentCriteriaIdsException $e) {
            }
        }
        return null;
    }
}
