<?php

declare(strict_types=1);

namespace Strix\BlueMedia\Hydrator;

use Shopware\Core\Checkout\Payment\Cart\AsyncPaymentTransactionStruct;
use Shopware\Core\System\SalesChannel\SalesChannelContext;
use Strix\BlueMedia\Helper\SessionSelectedGatewayHelper;
use Strix\BlueMedia\Provider\TransactionDataProvider;
use Strix\BlueMedia\Provider\ConfigProvider;
use Strix\BlueMedia\Provider\HashProvider;
use Shopware\Core\Framework\Context;
use Strix\BlueMedia\WebService\BmPaymentRequestBuilder;

class PaymentRequestHydrator
{
    /**
     * @var TransactionDataProvider
     */
    private $transactionDataProvider;

    /**
     * @var ConfigProvider
     */
    private $configProvider;

    /**
     * @var HashProvider
     */
    private $hashProvider;

    /**
     * @var BmPaymentRequestBuilder
     */
    private $bmPaymentRequestBuilder;

    /**
     * @var SessionSelectedGatewayHelper
     */
    private $sessionSelectedGatewayHelper;

    /**
     * @param TransactionDataProvider $transactionDataProvider
     * @param ConfigProvider $configProvider
     * @param HashProvider $hashProvider
     * @param BmPaymentRequestBuilder $bmPaymentRequestBuilder
     * @param SessionSelectedGatewayHelper $sessionSelectedGatewayHelper
     */
    public function __construct(
        TransactionDataProvider $transactionDataProvider,
        ConfigProvider $configProvider,
        HashProvider $hashProvider,
        BmPaymentRequestBuilder $bmPaymentRequestBuilder,
        SessionSelectedGatewayHelper $sessionSelectedGatewayHelper
    ) {
        $this->transactionDataProvider = $transactionDataProvider;
        $this->configProvider = $configProvider;
        $this->hashProvider = $hashProvider;
        $this->bmPaymentRequestBuilder = $bmPaymentRequestBuilder;
        $this->sessionSelectedGatewayHelper = $sessionSelectedGatewayHelper;
    }

    /**
     * @param AsyncPaymentTransactionStruct $transaction
     * @param SalesChannelContext $context
     *
     * @return string
     */
    public function hydratePaymentUrl(AsyncPaymentTransactionStruct $transaction, SalesChannelContext $context): string
    {
        $this->bmPaymentRequestBuilder
            ->setUrl($this->configProvider->getPaymentRedirectUrl())
            ->setOrderId($transaction->getOrder()->getOrderNumber())
            ->setAmount($this->transactionDataProvider->getOrderAmount($transaction))
            ->setCurrency($this->transactionDataProvider->getOrderCurrencyCode($transaction, $context->getContext()))
            ->setCustomerEmail($this->transactionDataProvider->getOrderCustomerEmail($transaction))
            ->setServiceId($this->configProvider->getServiceId())
            ->setKey($this->configProvider->getSharedKey());

        $gateway = $this->sessionSelectedGatewayHelper->getSelectedGateway($context);
        if($gateway) {
            $this->bmPaymentRequestBuilder
                ->setGatewayId($gateway->getGatewayId())
                ->setCurrency($gateway->getGatewayCurrency());
        }

        return $this->bmPaymentRequestBuilder->build();
    }
}
