<?php

declare(strict_types=1);

namespace Strix\BlueMedia\Migration;

use Doctrine\DBAL\Connection;
use Shopware\Core\Framework\Migration\MigrationStep;
use Strix\BlueMedia\Payment\BmStandardPayment;

class Migration1589801649 extends MigrationStep
{
    public function getCreationTimestamp(): int
    {
        return 1589801649;
    }

    public function update(Connection $connection): void
    {
        $bmPaymentMethod = $this->getBmPaymentMethod($connection);
        if ($bmPaymentMethod) {
            $this->updateHandlerIdentifier($connection, $bmPaymentMethod);
            $this->updatePluginId($connection, $bmPaymentMethod);
        }
    }

    public function updateDestructive(Connection $connection): void
    {
    }

    private function getBmPaymentMethod(Connection $connection): ?array
    {
        $result = $connection->fetchAll(
            "SELECT *  FROM `payment_method` WHERE `handler_identifier` LIKE ?;",
            ['Strix\\\\BlueMedia\\\\Service\\\\BlueAsynchronousPayment']
        );

        if ($result) {
            return current($result);
        }

        return null;
    }

    private function updateHandlerIdentifier(Connection $connection, array $bmPaymentMethod)
    {
        $connection->executeQuery(
            "UPDATE `payment_method` SET `handler_identifier` = ? WHERE `payment_method`.`id` = ?;",
            [
                BmStandardPayment::class,
                $bmPaymentMethod['id']
            ]
        );
    }

    private function updatePluginId(Connection $connection, array $bmPaymentMethod)
    {
        if (empty($bmPaymentMethod['plugin_id'])) {
            $bmPlugin = $this->getBmPlugin($connection);
            if ($bmPlugin) {
                $connection->executeQuery(
                    "UPDATE `payment_method` SET `plugin_id` = ? WHERE `payment_method`.`id` = ?;",
                    [
                        $bmPlugin['id'],
                        $bmPaymentMethod['id']
                    ]
                );
            }
        }
    }

    private function getBmPlugin(Connection $connection): ?array
    {
        $result = $connection->fetchAll(
            "SELECT *  FROM `plugin` WHERE `base_class` LIKE ?;",
            ['Strix\\\\BlueMedia\\\\BluePayment']
        );

        if ($result) {
            return current($result);
        }

        return null;
    }
}
