<?php

declare(strict_types=1);

namespace Strix\BlueMedia\Provider;

use Shopware\Core\Framework\Context;
use Shopware\Core\Framework\DataAbstractionLayer\EntityRepositoryInterface;
use Shopware\Core\Framework\DataAbstractionLayer\Search\Criteria;
use Shopware\Core\Framework\DataAbstractionLayer\Search\Filter\EqualsFilter;
use Strix\BlueMedia\Payment\BmSeparatedPayment;
use Strix\BlueMedia\Payment\BmStandardPayment;

class BmPaymentProvider
{
    /**
     * @var EntityRepositoryInterface
     */
    private $paymentMethodRepository;

    /**
     * @var ?string
     */
    private $standardPaymentMethodId = null;

    /**
     * @param EntityRepositoryInterface $paymentMethodRepository
     */
    public function __construct(
        EntityRepositoryInterface $paymentMethodRepository
    ) {
        $this->paymentMethodRepository = $paymentMethodRepository;
    }

    /**
     * @return string|null
     */
    public function getStandardPaymentMethodId(): ?string
    {
        if(!$this->standardPaymentMethodId) {
            $criteria = new Criteria();
            $criteria->addFilter(new EqualsFilter('handlerIdentifier', BmStandardPayment::class));
            $this->standardPaymentMethodId = $this->paymentMethodRepository->searchIds($criteria, Context::createDefaultContext())->firstId();
        }
        return $this->standardPaymentMethodId;
    }

    /**
     * @return array
     */
    public function getSeparatedPaymentMethodIds(): array
    {
        $criteria = new Criteria();
        $criteria->addFilter(new EqualsFilter('handlerIdentifier', BmSeparatedPayment::class));
        return $this->paymentMethodRepository->searchIds($criteria, Context::createDefaultContext())->getIds();
    }
}
