<?php

declare(strict_types=1);

namespace Strix\BlueMedia\Provider;

use Shopware\Core\System\SystemConfig\SystemConfigService;

class ConfigProvider
{
    const HASH_ALGORITHM = 'sha256';
    const HASH_SEPARATOR = '|';
    const PAYMENT_URL = 'https://pay.bm.pl/payment';
    const TEST_PAYMENT_URL = 'https://pay-accept.bm.pl/payment';
    const CHECKOUT_SUCCESS_URL = '/checkout/finish?orderId=';
    const GATEWAYS_URL = 'https://pay.bm.pl/paywayList';
    const TEST_GATEWAYS_URL = 'https://pay-accept.bm.pl/paywayList';

    /**
     * @var SystemConfigService
     */
    private $systemConfigService;

    /**
     * @param SystemConfigService $systemConfigService
     */
    public function __construct(SystemConfigService $systemConfigService)
    {
        $this->systemConfigService = $systemConfigService;
    }

    /**
     * @return int
     */
    public function getServiceId(): int
    {
        return (int) $this->systemConfigService->get('BluePayment.config.serviceID');
    }

    /**
     * @return string
     */
    public function getSharedKey(): string
    {
        return (string) $this->systemConfigService->get('BluePayment.config.sharedKey');
    }

    /**
     * @return string
     */
    public function getProcessPaymentOrderStatus(): string
    {
        return (string) $this->systemConfigService->get('BluePayment.config.processPaymentOrderStatus');
    }

    /**
     * @return string
     */
    public function getFinishPaymentOrderStatus(): string
    {
        return (string) $this->systemConfigService->get('BluePayment.config.finishPaymentOrderStatus');
    }



    /**
     * @return int
     */
    public function getTransactionLifeHours(): int
    {
        return (int) $this->systemConfigService->get('BluePayment.config.transactionLifeHours');
    }

    /**
     * @return string
     */
    public function getHashAlgorithm(): string
    {
        return static::HASH_ALGORITHM;
    }

    /**
     * @return string
     */
    public function getHashSeparator(): string
    {
        return static::HASH_SEPARATOR;
    }

    /**
     * @return string
     */
    public function getPaymentRedirectUrl(): string
    {
        if ((bool)$this->systemConfigService->get('BluePayment.config.testMode') === true) {
            return static::TEST_PAYMENT_URL;
        }

        return static::PAYMENT_URL;
    }

    public function getGatewaysRequestUrl(): string
    {
        if ((bool) $this->systemConfigService->get('BluePayment.config.testMode') === true) {
            return static::TEST_GATEWAYS_URL;
        }

        return static::GATEWAYS_URL;
    }

    public function getCheckoutSuccessUrl(): string
    {
        return static::CHECKOUT_SUCCESS_URL;
    }
}
