import template from './sw-entity-single-select-bluemedia-strix.html.twig';

const {Component, Mixin} = Shopware;
const {Criteria} = Shopware.Data;

Component.register('sw-entity-single-select-bluemedia-strix', {
    template,

    mixins: [
        Mixin.getByName('sw-inline-snippet')
    ],

    data() {
        return {
            criteria: null,
            label: ''
        };
    },

    created() {
        this.createCriteria();
        this.setLabel();
    },

    methods: {
        createCriteria() {
            const criteria = new Criteria(1, this.resultLimit);
            criteria.addAssociation('stateMachine');
            criteria.addFilter(
                Criteria.equals(
                    'state_machine_state.stateMachine.technicalName',
                    'order.state'
                )
            );
            this.criteria = criteria;
        },

        setLabel() {
            if (this.$attrs.label) {
                this.label = this.getInlineSnippet(this.$attrs.label);
            }
        }
    }
});
