import Plugin from 'src/plugin-system/plugin.class';

export default class ProductQty extends Plugin {
    static options = {
        parentElementSelector: '.payment-method',
        hideClass: 'd-none'
    };

    init() {
        this.radioEl = this.getRadioEl(this.el, this.options.parentElementSelector);
        this.radioElValue = this.radioEl.value;
        this.showElement = true;
        this.setInitState(this.radioEl.checked);
        this.initInputListeners(this.radioEl.name);
    }

    getRadioEl(el, parentSelector) {
        return el.closest(parentSelector).querySelector('input[type=radio]');
    }

    setInitState(checked) {
        if (!checked) {
            this.toggleHandler(false);
        }
    }

    initInputListeners(name) {
        const nodeList = document.querySelectorAll(`${this.options.parentElementSelector} input[name=${name}]`);

        nodeList.forEach((el) => {
            this.bindEvent(el);
        })
    }

    bindEvent(el) {
        el.addEventListener('change', this.changeHandler.bind(this));
    }

    changeHandler(e) {
        this.toggleHandler(e.target.value === this.radioElValue);
    }

    toggleHandler(checked) {
        if (this.showElement !== checked) {
            const props = {
                element: this.el,
                className: this.options.hideClass
            };

            if (checked) {
                this.removeClass(props);
            } else {
                this.addClass(props);
            }
            this.showElement = checked;
        }
    }

    removeClass({element, className}) {
        element.classList.remove(className);
    }

    addClass({element, className}) {
        element.classList.add(className);
    }
}
