<?php

declare(strict_types=1);

namespace Strix\BlueMedia\WebService;

class BmPaymentRequestFields
{
    const SERVICE_ID_KEY = 'ServiceID';
    const ORDER_ID_KEY = 'OrderID';
    const AMOUNT_KEY = 'Amount';
    const DESCRIPTION_KEY = 'Description';
    const GATEWAY_ID_KEY = 'GatewayID';
    const CURRENCY_KEY = 'Currency';
    const CUSTOMER_EMAIL_KEY = 'CustomerEmail';
    const VALIDITY_TIME_KEY = 'ValidityTime';
    const LINK_VALIDITY_TIME_KEY = 'LinkValidityTime';
    const HASH_KEY = 'Hash';

    private $options = [
        self::SERVICE_ID_KEY => [
            'sortOrder' => 1,
            'isRequired' => true,
            'isUsedForHash' => true,
        ],
        self::ORDER_ID_KEY => [
            'sortOrder' => 2,
            'isRequired' => true,
            'isUsedForHash' => true,
        ],
        self::AMOUNT_KEY => [
            'sortOrder' => 3,
            'isRequired' => true,
            'isUsedForHash' => true,
        ],
        self::DESCRIPTION_KEY => [
            'sortOrder' => 4,
            'isRequired' => false,
            'isUsedForHash' => true,
        ],
        self::GATEWAY_ID_KEY => [
            'sortOrder' => 5,
            'isRequired' => false,
            'isUsedForHash' => true,
        ],
        self::CURRENCY_KEY => [
            'sortOrder' => 6,
            'isRequired' => false,
            'isUsedForHash' => true,
        ],
        self::CUSTOMER_EMAIL_KEY => [
            'sortOrder' => 7,
            'isRequired' => false,
            'isUsedForHash' => true,
        ],
        self::VALIDITY_TIME_KEY => [
            'sortOrder' => 19,
            'isRequired' => false,
            'isUsedForHash' => true,
        ],
        self::LINK_VALIDITY_TIME_KEY => [
            'sortOrder' => 34,
            'isRequired' => false,
            'isUsedForHash' => true,
        ],
        self::HASH_KEY => [
            'sortOrder' => null,
            'isRequired' => true,
            'isUsedForHash' => false,
        ],
    ];

    /**
     * @param string $key
     * @return int|null
     * @throws \Exception
     */
    private function getFieldSortOrder(string $key): ?int
    {
        if(!array_key_exists($key, $this->options)) {
            throw new  \Exception();
        }
        return $this->options[$key]['sortOrder'];
    }

    /**
     * @param string $key
     * @return bool
     * @throws \Exception
     */
    private function getIsRequired(string $key): bool
    {
        if(!array_key_exists($key, $this->options)) {
            throw new  \Exception();
        }
        return $this->options[$key]['isRequired'];
    }

    /**
     * @param string $key
     * @return bool
     * @throws \Exception
     */
    private function getIsUsedForHash(string $key): bool
    {
        if(!array_key_exists($key, $this->options)) {
            throw new  \Exception();
        }
        return $this->options[$key]['isUsedForHash'];
    }

    /**
     * @param array $data
     * @return array
     */
    public function sortFields(array $data): array
    {
        uksort($data, function($aKey, $bKey) {
            $a = $this->getFieldSortOrder($aKey);
            $b = $this->getFieldSortOrder($bKey);
            if($a == $b) {
                return 0;
            }
            return ($a < $b) ? -1 : 1;
        });
        return $data;
    }
}
