<?php

declare(strict_types=1);

namespace Strix\BlueMedia\WebService;

use GuzzleHttp\Client as GuzzleHttp;
use GuzzleHttp\Exception\GuzzleException;
use SimpleXMLElement;
use Strix\BlueMedia\Exception\InvalidApiCallResponseException;

class Client
{
    /**
     * @param string $endPoint
     * @param array $data
     *
     * @return SimpleXMLElement
     * @throws InvalidApiCallResponseException
     */
    public function call(string $endPoint, array $data): SimpleXMLElement
    {
        $response = (new GuzzleHttp())->post(
            $endPoint,
            [
                'form_params' => $data,
            ]
        );

        if($response->getStatusCode() != 200) {
            throw new InvalidApiCallResponseException();
        }

        $responseData = $response->getBody()->getContents();
        if ($responseData == 'ERROR') {
            throw new InvalidApiCallResponseException();
        }

        return simplexml_load_string($responseData);
    }

    /**
     * @param array $data
     *
     * @return string
     */
    private function buildFields(array $data): string
    {
        return http_build_query($data);
    }

}
