<?php

declare(strict_types=1);

namespace Strix\BlueMedia\Command;

use Strix\BlueMedia\Exception\InvalidApiCallResponseException;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;
use Strix\BlueMedia\Processor\GatewaySynchronizationProcessor;

class GatewaySynchronization extends Command
{
    /**
     * @var GatewaySynchronizationProcessor
     */
    private $gatewaySynchronizationProcessor;

    /**
     * @param GatewaySynchronizationProcessor $gatewaySynchronizationProcessor
     * @param string|null $name
     */
    public function __construct(GatewaySynchronizationProcessor $gatewaySynchronizationProcessor, string $name = null)
    {
        $this->gatewaySynchronizationProcessor = $gatewaySynchronizationProcessor;
        parent::__construct($name);
    }

    /**
     * @return void
     */
    protected function configure(): void
    {
        $this->setName('strix:blue-media:synchronize');
    }

    /**
     * @param InputInterface $input
     * @param OutputInterface $output
     * @throws InvalidApiCallResponseException
     */
    protected function execute(InputInterface $input, OutputInterface $output): void
    {
        $this->gatewaySynchronizationProcessor->processGatewaySynchronization();
        $output->writeln('Synchronization finished.');
    }
}
