<?php

declare(strict_types=1);

namespace Strix\BlueMedia\Entity;

use Shopware\Core\Checkout\Payment\PaymentMethodDefinition;
use Shopware\Core\Content\Media\MediaDefinition;
use Shopware\Core\Framework\DataAbstractionLayer\EntityDefinition;
use Shopware\Core\Framework\DataAbstractionLayer\Field\BoolField;
use Shopware\Core\Framework\DataAbstractionLayer\Field\FkField;
use Shopware\Core\Framework\DataAbstractionLayer\Field\Flag\PrimaryKey;
use Shopware\Core\Framework\DataAbstractionLayer\Field\Flag\Required;
use Shopware\Core\Framework\DataAbstractionLayer\Field\IdField;
use Shopware\Core\Framework\DataAbstractionLayer\Field\IntField;
use Shopware\Core\Framework\DataAbstractionLayer\Field\LongTextField;
use Shopware\Core\Framework\DataAbstractionLayer\Field\ManyToOneAssociationField;
use Shopware\Core\Framework\DataAbstractionLayer\Field\StringField;
use Shopware\Core\Framework\DataAbstractionLayer\FieldCollection;

class GatewayEntityDefinition extends EntityDefinition
{
    public const ENTITY_NAME = 'blue_media_gateway';

    /**
     * @return string
     */
    public function getEntityName(): string
    {
        return static::ENTITY_NAME;
    }

    /**
     * @return string
     */
    public function getCollectionClass(): string
    {
        return GatewayEntityCollection::class;
    }

    /**
     * @return string
     */
    public function getEntityClass(): string
    {
        return GatewayEntity::class;
    }

    /**
     * @return array
     */
    public function getDefaults(): array
    {
        return [
            'gatewayCurrency' => 'PLN',
            'gatewayStatus' => true,
            'isSeparatedMethod' => false,
            'forceDisable' => false,
            'position' => 1,
            'useOwnLogo' => false,
        ];
    }

    /**
     * @return FieldCollection
     */
    protected function defineFields(): FieldCollection
    {
        return new FieldCollection([
            (new IdField('id', 'id'))->addFlags(new PrimaryKey(), new Required()),
            (new StringField('gateway_currency', 'gatewayCurrency', 5))->addFlags(new Required()),
            (new BoolField('gateway_status', 'gatewayStatus'))->addFlags(new Required()),
            (new IntField('gateway_id', 'gatewayId'))->addFlags(new Required()),
            (new StringField('bank_name', 'bankName', 100))->addFlags(new Required()),
            (new StringField('gateway_name', 'gatewayName', 100))->addFlags(new Required()),
            new LongTextField('gateway_description', 'gatewayDescription'),
            (new StringField('gateway_type', 'gatewayType', 50))->addFlags(new Required()),
            new StringField('gateway_logo_url', 'gatewayLogoUrl'),
            (new BoolField('is_separated_method', 'isSeparatedMethod'))->addFlags(new Required()),
            (new BoolField('force_disable', 'forceDisable'))->addFlags(new Required()),
            new IntField('position', 'position'),
            (new BoolField('use_own_logo', 'useOwnLogo'))->addFlags(new Required()),
            new FkField('media_id', 'mediaId', MediaDefinition::class),
            new ManyToOneAssociationField('media', 'media_id', MediaDefinition::class),
            new FkField('payment_method_id', 'paymentMethodId', PaymentMethodDefinition::class),
            new ManyToOneAssociationField('paymentMethod', 'payment_method_id', PaymentMethodDefinition::class, 'id', false),
        ]);
    }
}
