<?php

declare(strict_types=1);

namespace Strix\BlueMedia\Migration;

use Doctrine\DBAL\Connection;
use Shopware\Core\Framework\Migration\MigrationStep;

class Migration1585783853 extends MigrationStep
{
    public function getCreationTimestamp(): int
    {
        return 1585783853;
    }

    public function update(Connection $connection): void
    {
        $connection->executeQuery("DROP TABLE IF EXISTS `blue_media_gateway`");
        $connection->executeQuery("
            CREATE TABLE `blue_media_gateway` (
                `id` BINARY(16) NOT NULL,
                `gateway_currency` VARCHAR(5) NOT NULL,
                `gateway_status` TINYINT(1) NOT NULL DEFAULT '0',
                `gateway_id` INT(11) NOT NULL,
                `bank_name` VARCHAR(100) NOT NULL,
                `gateway_name` VARCHAR(100) NOT NULL,
                `gateway_description` LONGTEXT NULL,
                `gateway_type` VARCHAR(50) NOT NULL,
                `gateway_logo_url` VARCHAR(255) NULL,
                `is_separated_method` TINYINT(1) NOT NULL DEFAULT '0',
                `force_disable` TINYINT(1) NOT NULL DEFAULT '0',
                `position` INT(11) NULL,
                `use_own_logo` TINYINT(1) NOT NULL DEFAULT '0',
                `media_id` BINARY(16) NULL,
                `payment_method_id` BINARY(16) NULL,
                `created_at` DATETIME(3) NOT NULL,
                `updated_at` DATETIME(3) NOT NULL,
                PRIMARY KEY (`id`),
                KEY `fk.blue_media_gateway.media_id` (`media_id`),
                KEY `fk.blue_media_gateway.payment_method_id` (`payment_method_id`),
                CONSTRAINT `fk.blue_media_gateway.media_id` FOREIGN KEY (`media_id`) REFERENCES `media` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
                CONSTRAINT `fk.blue_media_gateway.payment_method_id` FOREIGN KEY (`payment_method_id`) REFERENCES `payment_method` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
            ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
        ");
    }

    public function updateDestructive(Connection $connection): void
    {
    }
}
