<?php

declare(strict_types=1);

namespace Strix\BlueMedia\Provider;

class HashProvider
{
    /**
     * @var ConfigProvider
     */
    private $configProvider;

    /**
     * @param ConfigProvider $configProvider
     */
    public function __construct( ConfigProvider $configProvider ) {
        $this->configProvider = $configProvider;
    }

    /**
     * @param array $hashData
     *
     * @return string
     */
    public function getHash(array $hashData): string
    {
        $algorithm = $this->configProvider->getHashAlgorithm();
        $separator = $this->configProvider->getHashSeparator();
        $valuesArray = array_values($hashData);
        $valuesArrayFilter = array_filter(($valuesArray));
        $hashString = implode($separator, $valuesArrayFilter);
        $hash = hash($algorithm, $hashString);

        return $hash;
    }
}
