import './page/strix-bluemedia-gateways';
import './page/strix-bluemedia-gateways-detail';
import enGB from './snippet/en-GB.json';

const { Module } = Shopware;

Module.register('strix-bluemedia', {
    type: 'plugin',
    name: 'Blue Media',
    title: 'strixBluemedia.menu.mainMenuLabel',
    description: 'strixBluemedia.moduleDescription',
    color: '#0063BE',
    icon: 'default-money-wallet',

    snippets: {
        'en-GB': enGB
    },

    routes: {
        gateways: {
            component: 'strix-bluemedia-gateways',
            path: 'gateways',
        },
        detail: {
            component: 'strix-bluemedia-gateways-detail',
            path: 'detail/:id',
        },
    },

    navigation: [{
        id: 'strix-bluemedia',
        label: 'strixBluemedia.menu.mainMenuLabel',
        color: '#0063BE',
        icon: 'default-money-wallet'
    },{
        id: 'strix-bluemedia-gateways',
        path: 'strix.bluemedia.gateways',
        label: 'strixBluemedia.menu.gatewaysLabel',
        parent: 'strix-bluemedia'
    },{
        id: 'strix-bluemedia-payments',
        path: 'sw.settings.payment.index',
        label: 'strixBluemedia.menu.paymentsLabel',
        parent: 'strix-bluemedia'
    },{
        id: 'strix-bluemedia-settings',
        path: 'sw.plugin.settings',
        params: {
            namespace: 'BluePayment'
        },
        label: 'strixBluemedia.menu.settingsLabel',
        parent: 'strix-bluemedia'
    }]
});
