import template from './strix-bluemedia-gateways-detail.html.twig';

const {Component, Mixin} = Shopware;

Component.register('strix-bluemedia-gateways-detail', {
    template,

    inject: ['repositoryFactory'],

    mixins: [
        Mixin.getByName('notification')
    ],

    metaInfo() {
        return {
            title: this.$createTitle()
        };
    },

    data() {
        return {
            gateway: null,
            isLoading: false,
            processSuccess: false,
            optionsActiveInactive: [
                {value: true, name: this.$t('strixBluemedia.detail.active')},
                {value: false, name: this.$t('strixBluemedia.detail.inactive')}
            ]
        };
    },

    computed: {
        repository() {
            return this.repositoryFactory.create('blue_media_gateway');
        },
        mediaRepository() {
            return this.repositoryFactory.create('media');
        }
    },

    created() {
        this.getGateway();
    },

    methods: {
        getGateway() {
            this.repository
                .get(this.$route.params.id, Shopware.Context.api)
                .then((entity) => {
                    this.gateway = entity;
                    this.getGatewayMedia(entity.mediaId)
                });
        },
        openMediaSidebar() {
            this.$refs.mediaSidebarItem.openContent();
        },

        setMedia(media) {
            this.gateway.media = media;
            this.gateway.mediaId = media ? media.id : null;
            this.gateway.gatewayLogoPath = media ? media.url : null;
        },
        getGatewayMedia(id) {
            if (id) {
                this.mediaRepository.get(id, Shopware.Context.api).then((media) => {
                    this.setMedia(media)
                });
            }
        },

        onClickSave() {
            if (this.validateUseOwnLogo()) {
                this.isLoading = true;

                this.repository
                    .save(this.gateway, Shopware.Context.api)
                    .then(() => {
                        this.getGateway();
                        this.isLoading = false;
                        this.processSuccess = true;
                        this.createNotificationSuccess({
                            title: this.$t('strixBluemedia.gateways.success'),
                            message: this.$t('strixBluemedia.gateways.saveSuccessMessage')
                        });
                    }).catch((exception) => {
                    this.isLoading = false;
                    this.createNotificationError({
                        title: this.$t('global.default.error'),
                        message: exception
                    });
                });
            }
        },

        saveFinish() {
            this.processSuccess = false;
        },

        validateUseOwnLogo() {
            if (this.gateway.useOwnLogo && !this.gateway.mediaId) {
                this.createNotificationError({
                    title: this.$t('global.default.error'),
                    message: this.$t('strixBluemedia.detail.useOwnLogoError'),
                });
                return false;
            }
            return true;
        }
    }
});
