import template from './strix-bluemedia-gateways.html.twig';

const {Component, Mixin} = Shopware;
const {Criteria} = Shopware.Data;

Component.register('strix-bluemedia-gateways', {
    template,

    inject: [
        'repositoryFactory'
    ],

    mixins: [
        Mixin.getByName('notification')
    ],
    data() {
        return {
            repository: this.repositoryFactory.create('blue_media_gateway'),
            gatewayList: null,
            isLoading: false,
            isSaveSuccessful: false,
            sortEnable: true,
            sortBy: 'position',
            sortDirection: 'ASC',
            httpClient: null,
            syncService: null,
            columns: [{
                property: 'gatewayId',
                label: 'Id',
                align: 'center',
                allowResize: true,
            }, {
                property: 'gatewayCurrency',
                label: this.$t('strixBluemedia.gateways.fields.currency'),
                allowResize: true,
                sortable: false,
                visible: false
            }, {
                property: 'gatewayStatus',
                label: this.$t('strixBluemedia.gateways.fields.status'),
                allowResize: true,
            }, {
                property: 'bankName',
                label: this.$t('strixBluemedia.gateways.fields.bankName'),
                allowResize: true,
            }, {
                property: 'gatewayName',
                label: this.$t('strixBluemedia.gateways.fields.name'),
                allowResize: true,
                width: '300px'
            }, {
                property: 'gatewayDescription',
                label: this.$t('strixBluemedia.gateways.fields.description'),
                allowResize: true,
                visible: false
            }, {
                property: 'position',
                label: this.$t('strixBluemedia.gateways.fields.sortOrder'),
                allowResize: true,
                primary: true,
                align: 'center',
                width: '150px'

            }, {
                property: 'gatewayType',
                label: this.$t('strixBluemedia.gateways.fields.type'),
                allowResize: true,
                visible: false
            }, {
                property: 'isSeparatedMethod',
                label: this.$t('strixBluemedia.gateways.fields.isSeparatedMethod'),
                allowResize: true,
                align: 'center',
            }, {
                property: 'forceDisable',
                label: this.$t('strixBluemedia.gateways.fields.forceDisable'),
                allowResize: true,
            }, {
                property: 'useOwnLogo',
                label: this.$t('strixBluemedia.gateways.fields.useOwnLogo'),
                allowResize: true,
                align: 'center',
                visible: false
            }, {
                property: 'gatewayLogoPath',
                label: this.$t('strixBluemedia.gateways.fields.logoPath'),
                allowResize: true,
                align: 'center',
                visible: false
            }, {
                property: 'statusDate',
                label: this.$t('strixBluemedia.gateways.fields.statusDate'),
                allowResize: true,
                visible: false
            }, {
                property: 'updatedAt',
                label: this.$t('strixBluemedia.gateways.fields.updatedAt'),
                allowResize: true,
                visible: false
            }]
        }
    },

    created() {
        this.getList();
    },

    methods: {
        getList() {
            this.isLoading = true;

            this.repository
                .search(new Criteria(), Shopware.Context.api)
                .then((result) => {
                    this.isLoading = false;
                    this.gatewayList = this.sortList(result);
                });
        },

        sortList(result) {
            return result.sort((a, b) => {
                if (a[this.sortBy] > b[this.sortBy]) {
                    return this.sortDirection === 'ASC' ? 1 : -1;
                }
                if (a[this.sortBy] < b[this.sortBy]) {
                    return this.sortDirection === 'ASC' ? -1 : 1;
                }
                return 0;
            })
        },

        onPositionChanged(payment) {
            this.isLoading = true;

            this.repository.sync(payment, Shopware.Context.api)
                .then(() => {
                    this.getList();
                    this.createNotificationSuccess({
                        title: this.$t('strixBluemedia.gateways.success'),
                        message: this.$t('strixBluemedia.gateways.sortSuccessMessage')
                    });
                })
                .catch(() => {
                    this.getList();
                    this.createNotificationError({
                        title: this.$tc('global.default.error'),
                        message: this.$tc('global.notification.unspecifiedSaveErrorMessage')
                    });
                });
        },

        onColumnSort() {
            if (this.sortEnable) {
                this.sortEnable = false;
            }
        },

        reloadGateways() {
            this.isLoading = true;
            this.syncService = Shopware.Service('syncService');
            this.httpClient = this.syncService.httpClient;

            this.httpClient.get(
                '_action/gateway/synchronize',
                {
                    headers: this.syncService.getBasicHeaders()
                }
            ).then(() => {
                this.getList();
                this.createNotificationSuccess({
                    title: this.$t('strixBluemedia.gateways.success'),
                    message: this.$t('strixBluemedia.gateways.reloadSuccessMessage')
                });
            }).catch(() => {
                this.getList();
                this.createNotificationError({
                    title: this.$tc('global.default.error'),
                    message: this.$tc('global.notification.unspecifiedSaveErrorMessage')
                });
            });
        }
    }
});
