<?php

declare(strict_types=1);

namespace Strix\BlueMedia\ScheduledTask;

use Shopware\Core\Framework\DataAbstractionLayer\EntityRepositoryInterface;
use Shopware\Core\Framework\MessageQueue\ScheduledTask\ScheduledTaskHandler;
use Strix\BlueMedia\Processor\GatewaySynchronizationProcessor;

class GatewaySynchronizationTaskHandler extends ScheduledTaskHandler
{
    /**
     * @var GatewaySynchronizationProcessor
     */
    private $gatewaySynchronizationProcessor;

    /**
     * @param EntityRepositoryInterface $scheduledTaskRepository
     * @param GatewaySynchronizationProcessor $gatewaySynchronizationProcessor
     */
    public function __construct(
        EntityRepositoryInterface $scheduledTaskRepository,
        GatewaySynchronizationProcessor $gatewaySynchronizationProcessor
    ) {
        parent::__construct($scheduledTaskRepository);
        $this->gatewaySynchronizationProcessor = $gatewaySynchronizationProcessor;
    }

    /**
     * @return iterable
     */
    public static function getHandledMessages(): iterable
    {
        return [ GatewaySynchronizationTask::class ];
    }

    public function run(): void
    {
        $this->gatewaySynchronizationProcessor->processGatewaySynchronization();
    }
}
